#include "Photoshop.au3"

$oPs = _Photoshop_Create()

; Open an example image
$oDoc = _Photoshop_DocOpen($oPs, @ScriptDir&"\image2.jpg")

; Get the background layer (the only layer in this file)
$oLayer = _Photoshop_DocGetLayer($oDoc, 1)

; Copy and paste the layer (duplicate)
_Photoshop_ArtLayerCopy($oLayer)
_Photoshop_DocPaste($oDoc)

; Get the two layes
$oFrontLayer = _Photoshop_DocGetLayer($oDoc, 1)
$oBackLayer = _Photoshop_DocGetLayer($oDoc, 2)

$iRadius = 16

; Apply the High Pass and Median filters to the front layer and set the blending mode to Linear Light
_Photoshop_ArtLayerApplyHighPass($oFrontLayer, $iRadius)
_Photoshop_ArtLayerApplyMedian($oFrontLayer, 5)
_Photoshop_ArtLayerSetBlendMode($oFrontLayer, $PsLinearLight)

; Apply the Gaussian Blur filter to the back layer
_Photoshop_ArtLayerApplyGaussianBlur($oBackLayer, $iRadius)

; Uncomment to close the document
; _Photoshop_DocClose($oDoc)

; Uncomment to close Photoshop
; _Photoshop_Quit($oPs)